package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4613Request extends TxBaseRequest {
  /**
   * 银行账户绑定流水号
   * <p>
   * 注:格式:只能为数字字母开头和结尾, 中间可以包含 -,流水号前17位必须是时间戳 (yyyyMMddHHmmssSSS，数字)
   */
  @NotBlank(message = "银行账户绑定流水号不能为空")
  private String txSN;
  /**
   * 验证方式:
   * <p>
   * 10=短信验证
   * 20=小额打款验证
   */
  @NotBlank(message = "验证方式不能为空")
  private String verifyWay;
  /**
   * 短信验证码
   * <p>
   * 注:有效时间:15 分钟，验证方式:10时必填
   */
  private String sMSCode;
  /**
   * 信用卡背面的末3位数字
   */
  private String cVN2;
  /**
   * 信用卡有效期，格式 YYMM
   */
  private String validDate;
  /**
   * 打款金额
   * <p>
   * 注:单位:分，验证方式:20时必填;100 分(1 元)以内随机金额
   */
  private String amount;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element VerifyWay = document.createElement("VerifyWay");
    Element SMSCode = document.createElement("SMSCode");
    Element CVN2 = document.createElement("CVN2");
    Element ValidDate = document.createElement("ValidDate");
    Element Amount = document.createElement("Amount");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(VerifyWay);
    VerifyWay.setTextContent(this.verifyWay);
    Body.appendChild(SMSCode);
    SMSCode.setTextContent(this.sMSCode);
    Body.appendChild(CVN2);
    CVN2.setTextContent(this.cVN2);
    Body.appendChild(ValidDate);
    ValidDate.setTextContent(this.validDate);
    Body.appendChild(Amount);
    Amount.setTextContent(this.amount);
    postProcess(document);
  }
}

