/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice7709Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice7709Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice7709Strategy
implements NoticeStrategy<Notice7709Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice7709Strategy.class);
    @Autowired(required=false)
    private List<Notice7709Listener> notice7709Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_7709.getCode();
    }

    @Override
    public Notice7709Request exchange(NoticeRequest request) throws Exception {
        return new Notice7709Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice7709Request notice7709Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice7709Listeners)) {
                for (Notice7709Listener listener : this.notice7709Listeners) {
                    listener.onNotice(notice7709Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u58f9\u4f01\u4ed8\u7528\u6237\u7b7e\u7ea6\u6210\u529f\u540e\u53f0\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

