package com.biz.crm.common.pay.support.cpcn.base.common.http.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpConnection;
import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.common.http.ResponseDgtEnvlp;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;

/**
 * java默认网络库实现http请求
 *
 * @author Keller
 */
@Slf4j
@Setter
public class SimpleHttpConnection implements HttpConnection {
  /**
   * 网络请求方法
   */
  private String method = "POST";
  /**
   * 网络请求连接超时
   */
  private int connectTimeout = 50000;
  /**
   * 网络请求读取数据超时
   */
  private int readTimeout = 50000;
  /**
   * 输出字符编码
   */
  private String outputCharset = "UTF-8";
  /**
   * 输入字符编码
   */
  private String inputCharset = "UTF-8";
  /**
   * 请求头媒体类型
   */
  private String contentType = "application/x-www-form-urlencoded";

  /**
   * 通过list形式参数执行请求
   *
   * @param list
   * @return
   */
  @Override
  public String execute(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, this.outputCharset);
    String request = httpData.getData();
    return execute(uri, request);
  }

  @Override
  public ResponseDgtEnvlp executeRequest(String uri, List<NameValuePair> list) {
    return null;
  }

  @Override
  public String execute(String uri, String request) {
    HttpURLConnection httpUrlConnection;
    try {
      URL url = new URL(uri);
      httpUrlConnection = (HttpURLConnection) url.openConnection();
    } catch (IOException e) {
      throw new RuntimeException("初始化网络连接错误", e);
    }
    httpUrlConnection.setRequestProperty("Content-Type", this.contentType);

    httpUrlConnection.setDoOutput(true);
    httpUrlConnection.setDoInput(true);
    try {
      httpUrlConnection.setRequestMethod(this.method);
    } catch (ProtocolException e) {
      throw new IllegalArgumentException(String.format("不支持的请求类型[%s]", this.method), e);
    }
    httpUrlConnection.setUseCaches(false);
    httpUrlConnection.setConnectTimeout(this.connectTimeout);
    httpUrlConnection.setReadTimeout(this.readTimeout);
    InputStream inputStream = null;
    OutputStream outputStream = null;
    String response;
    try {
      outputStream = httpUrlConnection.getOutputStream();
      outputStream.write(request.getBytes(this.outputCharset));
      outputStream.flush();
      outputStream.close();

      inputStream = httpUrlConnection.getInputStream();
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] buffer = new byte[1024];
      int num = inputStream.read(buffer);
      while (num != -1) {
        baos.write(buffer, 0, num);
        num = inputStream.read(buffer);
      }
      baos.flush();
      response = (baos.toString(this.inputCharset)).trim();
      inputStream.close();
    } catch (IOException e) {
      log.error("发送请求出错", e);
      throw new RuntimeException("发送请求出错", e);
    } finally {
      if(outputStream !=null){
        try {
          outputStream.close();
        } catch (IOException e) {
          throw new RuntimeException(e.getMessage());
        }
      }
      if(inputStream !=null){
        try {
          inputStream.close();
        } catch (IOException e) {
          throw new RuntimeException(e.getMessage());
        }
      }
      if(httpUrlConnection != null){
        httpUrlConnection.disconnect();
      }
    }
    return response;
  }
}
