package com.biz.crm.common.pay.support.cpcn.model;

import lombok.Data;

/**
 * 5011-支付（API）
 * - 聚合支付 关心的数据
 *
 * @author hefan
 * @date 2022/08/25
 */
@Data
public class Tx5011QRPayModel extends Tx5011TransferModel {
  /**
   * 商品名称
   *
   * PaymentWay=02/40/42/80 必填
   */
  private String goodsName;

  /**
   * 聚合支付类型:
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   *
   * 支付方式: PaymentWay=40必填
   *
   */
  private String qRPaymentType;

  /**
   * 聚合支付方式:
   * 41=正扫
   * 42=反扫
   * 43=公众号(服务窗)
   * 44=小程序
   * 45=H5
   * 46=APP
   *
   * 支付方式: PaymentWay=40必填
   */
  private String qRPaymentWay;
  /**
   * 支付场景
   *
   * 10=条码支付
   * 20=声波支付
   * 90=刷脸支付
   *
   * 聚合支付方式 QRPaymentWay 为反扫时必填，默认10=条码支付
   */
  private String paymentScene = "10";
  /**
   * 预下单订单号
   *
   * 支付场景PaymentScene为90-刷脸支付为必输项，且必须与预下单交易一致
   */
  private String preTxSN;
  /**
   * 反扫支付授权码
   *
   * QRPaymentWay=42时必填
   */
  private String qRPayCode;
  /**
   * 付款用户 openid
   *
   * QRPaymentWay=43 、44时必填，微信: openid，支付宝: buyer_user_id
   */
  private String openID;
  /**
   * 商户 APPID
   *
   * QRPaymentWay=43、44、46时必填
   */
  private String merchantAppID;
  /**
   * 信用卡限制标识
   *
   *  QRPaymentWay=41/42时选填，默认10
   *
   *  10=信用卡可用
   *  20=信用卡不可用
   */
  private String qRLimitPay = "10";

  /**
   * 机具终端 ID
   *
   * 支付类型 QRPaymentType=30 银联，聚合支付方式为 42-反扫时必填
   */
  private String terminalID;
  /**
   * 取消支付后的前台跳转页面
   *
   * QRPaymentWay=41时,填入有效持卡人取消支付后跳转到此页面，应更换支付流水号后再次唤起支付。
   * 【需要注意】对于同一笔支付流水系统无法进行处理。
   */
  private String cancelPayRedirectPageURL;

  /**
   * 页面跳转方式
   * 10=公众号
   * 20=小程序
   *
   * QRPaymentType=10-微信扫码时此字段为必填项，默认为公众号
   */
  private String qRPageUrlType = "10";
  /**
   * 成功前台跳转页面
   *
   * QRPaymentWay=41时,填入有效此页面只用作商家广告宣传等展示，商户后台应只在收到中金后台的支付成功回调通知后，
   * 才能做真正的支付成功通知处理。
   */
  private String redirectPageURL;

}
