package com.biz.crm.common.pay.support.cpcn.base.cpcn.config;

import com.biz.crm.common.pay.support.cpcn.base.common.security.Signer;
import com.biz.crm.common.pay.support.cpcn.base.common.security.Verifier;
import lombok.Getter;
import lombok.Setter;

/**
 * 平台中金配置信息
 * 采用单机构单商户的模式进行
 *
 * @author Keller
 */
@Getter
@Setter
public class CpcnConfig {
  /**
   * 平台名称
   */
  private String platformName;
  /**
   * 加密算法
   */
  private String algorithm;

  /**
   * 是否使用数字信封
   */
  private Boolean isDgEnv;
  /**
   * 支付平台支付接口地址
   */
  private String paymentUrl;
  /**
   * 支付平台交易接口地址
   */
  private String txUrl;
  /**
   * 统一下单接口地址
   */
  private String gateway4aggregatePaymentUrl;
  /**
   * 支付平台交易接口地址
   */
  private String gateway4aggregateTxUrl;
  /**
   * Gateway4File
   */
  private String gateway4fileUrl;
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 商户名称
   */
  private String name;
  /**
   * 证书密码
   */
  private String password;
  /**
   * 签名
   */
  private Signer signer;
  /**
   * 验证
   */
  private Verifier verifier;
  /**
   * 加密类型 10:国际加密 20:国密加密
   */
  private String encryptType;
  /**
   * 回调通知地址
   */
  private String noticeUrl;

  /**
   * 调试开关 打开次开会针对中金的测试环境（将会采用测试环境特定的测试数据）
   */
  private boolean debug;
}
