package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit.Tx2734Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit.Tx2734Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 2734-商户进件
 *
 * <pre>
 *     2734 是商户进件，机构系统通过该接口可以实现聚合支付交易 商户自主进件的功能，机构系统提交交易请求后，支付平台会同步返回进件状态。
 *     如果进件状态为20-受理成功，机构系统后续可以通过2735-进件状态查询接口来同步进件最终结果。
 *     注:行业类别字段(<Category>)内容必须使用行业类别代码填 写，行业类别代码详见《商户进件行业类别代码表》
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx2734Strategy extends AbstractTxStrategy<Tx2734Request, Tx2734Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_2734_REQUEST.getCode();
  }

  @Override
  public Class<Tx2734Response> getResponse() {
    return Tx2734Response.class;
  }
}
