package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4601Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4601Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4601-开户
 *
 * <pre>
 *    4601-开户接口用于个人、企业用户或个体工商户在机构系统开立银行电子账户环节。
 *    用户在机构系统进行银行电子账户开户操作时，机构系统通过该接口将用户提交的开户信息发送到支付平台，
 *    支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4601Strategy extends AbstractTxStrategy<Tx4601Request, Tx4601Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4601_REQUEST.getCode();
  }

  @Override
  public Class<Tx4601Response> getResponse() {
    return Tx4601Response.class;
  }
}
