package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4695-用户权限开通查询
 * <p>
 * 机构系统使用该接口可以对指定用户 ID 对应的交易权限类型进行查询，支
 * 付平台返回该用户交易权限明细信息。
 *
 * @author hefan
 * @date 2022/08/22
 */
@Component
@Slf4j
public class Tx4695Strategy extends AbstractTxStrategy<Tx4695Request, Tx4695Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4695_REQUEST.getCode();
  }

  @Override
  public Class<Tx4695Response> getResponse() {
    return Tx4695Response.class;
  }
}
