package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.splitaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.List;

/**
 * 5031-延迟分账
 * 机构系统在进行 5011-支付（API）或 5012-支付（页面）时，
 * 如果 HasSubsequentSplit（是否有后续分账）字段的值为 2（即选择了延迟分账），
 * 那么后续可以使用本接口完成交易的延迟分账。机构系统通过该接口将分账请求发送到
 * 支付平台，支付平台同步返回分账处理结果。如果机构实时获取的分账交易状态
 * 是【10-处理中】，那么后续要通过 5036-延迟分账查询接口或者 5038-延迟分账
 * 通知来得到分账交易的结果
 * @Author dy
 * @DATE 2022/5/27
 **/
public class Tx5031Request extends TxBaseRequest {


  @NotBlank(message = "交易流水号不能为空")
  private String txSN;

  /**
   * 原支付交易流水
   * 号
   * 5011 接口返回的支付交易
   * 流水号
   */
  @NotBlank(message = "原支付交易流水不能为空")
  private String paymentTxSN;

  /**
   * 原支付交易时间，
   * 格式：yyyyMMdd；
   * 不上送只支持一年之内的支付交易查询
   */
  private String sourceTxTime;

  /**
   *本次分账后剩余资金处理方式:
   * 1=结算给收款人,
   * 2=等待后续分账
   * 默认值=2，
   * 1=按照分账明细进行分账，本次分账后的剩余资金结算给收款人。
   * 2=按照分账明细进行分账，本次分账后的剩余资金等待下次分账
   */
  private String remainFundsProcess;

  /**
   * 后台通知地址
   * 注：商户上传以这个地址为准，商户未上传以机构配置后台通知为准
   */
  @NotBlank(message = "后台通知地址不能为空")
  private String noticeURL;

  /**
   * 出现 1…n 次，n<=10,全部分账必填
   */
  @Valid
  @Size(min = 1,max = 10,message = "分账结算域最少出现1次，最多10次")
  private List<SplitItem> splitItems;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");

    Element TxSN = document.createElement("TxSN");
    Element PaymentTxSN = document.createElement("PaymentTxSN");
    Element SourceTxTime = document.createElement("SourceTxTime");
    Element RemainFundsProcess = document.createElement("RemainFundsProcess");
    Element NoticeURL = document.createElement("NoticeURL");

    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    TxCode.setTextContent(this.txCode);
    Head.appendChild(TxCode);

    Request.appendChild(Body);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(InstitutionID);

    TxSN.setTextContent(this.txSN);
    Body.appendChild(TxSN);
    PaymentTxSN.setTextContent(this.paymentTxSN);
    Body.appendChild(PaymentTxSN);
    SourceTxTime.setTextContent(this.sourceTxTime);
    Body.appendChild(SourceTxTime);
    RemainFundsProcess.setTextContent(this.sourceTxTime);
    Body.appendChild(RemainFundsProcess);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(NoticeURL);

    if(this.splitItems != null && this.splitItems.size() > 0){
      for (SplitItem splitItem : splitItems) {
        Element SplitItems = document.createElement("SplitItems");

        Element SplitTxSN = document.createElement("SplitTxSN");
        Element SplitUserID = document.createElement("SplitUserID");
        Element SplitAccountNumber = document.createElement("SplitAccountNumber");
        Element SplitBindingTxSN = document.createElement("SplitBindingTxSN");
        Element SplitBankAccountType = document.createElement("SplitBankAccountType");
        Element SplitBankID = document.createElement("SplitBankID");
        Element SplitBankAccountName = document.createElement("SplitBankAccountName");
        Element SplitBankAccountNumber = document.createElement("<SplitBankAccountNumber");
        Element SplitAmount = document.createElement("SplitAmount");
        Element SplitBranchName = document.createElement("SplitBranchName");
        Element SplitProvince = document.createElement("SplitProvince");
        Element SplitCity = document.createElement("SplitCity");
        Element CNAPSCode = document.createElement("CNAPSCode");
        Element Note = document.createElement("Note");






        Body.appendChild(SplitItems);

      }


    }



    postProcess(document);
  }
}
