package com.biz.crm.common.pay.support.cpcn.notifier;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice4668Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice4668Listener;
import com.biz.crm.common.pay.support.sdk.dto.WhiteListDto;
import com.biz.crm.common.pay.support.sdk.event.WhiteListListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 4668-白名单开通/注销通知
 *
 * @author hefan
 * @date 2022/08/19
 */
@Service
public class Notice4668ListenerImpl implements Notice4668Listener {

  @Autowired(required = false)
  private List<WhiteListListener> whiteListListeners;

  @Override
  public void onNotice(Notice4668Request request) {
    this.onEnable(request);
    this.onInvalid(request);
  }

  /**
   * 失效时通知
   *
   * @param request 请求
   */
  private void onInvalid(Notice4668Request request) {
    String status = request.getStatus();
    boolean isInvalid = "30".equals(status);
    if (!isInvalid) {
      return;
    }
    WhiteListDto dto = new WhiteListDto();
    dto.setSourceTxSN(request.getSourceTxSN());
    dto.setMessage(request.getResponseMessage());
    // 事件通知
    for (WhiteListListener listener : whiteListListeners) {
      listener.onInvalid(dto);
    }
  }

  /**
   * 启用时通知
   *
   * @param request 请求
   */
  private void onEnable(Notice4668Request request) {
    String status = request.getStatus();
    boolean isEnable = "20".equals(status);
    if (!isEnable) {
      return;
    }
    WhiteListDto dto = new WhiteListDto();
    dto.setSourceTxSN(request.getSourceTxSN());
    // 事件通知
    for (WhiteListListener listener : whiteListListeners) {
      listener.onEnable(dto);
    }

  }


}
