/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpsConnection;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.common.http.RequestDgtEnvlp;
import com.biz.crm.common.pay.support.cpcn.base.common.http.ResponseDgtEnvlp;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Base64Utils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTxStrategy<T extends TxBaseRequest, R extends TxBaseResponse> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTxStrategy.class);
    @Autowired
    protected HttpsConnection httpsConnection;
    @Autowired
    protected CpcnConfig cpcnConfig;
    @Autowired
    protected ValidatorFactory validatorFactory;

    public R handler(T request) {
        Object[] resp;
        ((TxBaseRequest)request).setCpcnConfig(this.cpcnConfig);
        ((TxBaseRequest)request).setValidator(this.validatorFactory.getValidator());
        ((TxBaseRequest)request).validate();
        try {
            ((TxBaseRequest)request).process();
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5c01\u88c5\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u5c01\u88c5\u5f02\u5e38", e);
        }
        TxBaseResponse response = null;
        log.info("\u8bf7\u6c42\u4e2d\u91d1\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)JSONObject.toJSONString(request));
        RequestDgtEnvlp requestDgtEnvlp = null;
        if (this.cpcnConfig.getIsDgEnv().booleanValue()) {
            requestDgtEnvlp = new RequestDgtEnvlp();
            requestDgtEnvlp.setDigitalEnvelope(((TxBaseRequest)request).getDgtlEnvlp());
            requestDgtEnvlp.setEncryptSN(((TxBaseRequest)request).getEncryptSN());
            requestDgtEnvlp.setSignAlgorithm(((TxBaseRequest)request).getSignAlgorithm());
            requestDgtEnvlp.setSignSN(((TxBaseRequest)request).getSignSN());
            requestDgtEnvlp.setIsDgEnv("YES");
            requestDgtEnvlp.setInstitutionID(this.cpcnConfig.getInstitutionID());
        }
        if (ObjectUtils.isEmpty((Object[])(resp = this.send(((TxBaseRequest)request).getRequestMessage(), ((TxBaseRequest)request).getRequestSignature(), ((TxBaseRequest)request).getRequestPlainText(), requestDgtEnvlp))) || resp.length <= 1) {
            throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u4e0d\u7b26\u5408\u683c\u5f0f");
        }
        if ("YES".equals(resp[2])) {
            try {
                log.info("\u5f00\u59cb\u5bf9\u54cd\u5e94\u6d88\u606f\u505a\u5bf9\u79f0\u89e3\u5bc6\u3002\u3002\u3002\u3002\u3002\u3002");
                resp[0] = this.cpcnConfig.getSigner().decrypt((String)resp[0], (String)resp[3]);
                resp[0] = new String(Base64Utils.encode((byte[])((String)resp[0]).getBytes("UTF-8")));
                log.info("\u54cd\u5e94\u6d88\u606f\u505a\u5bf9\u79f0\u89e3\u5bc6\u5b8c\u6210\u3002\u3002\u3002\u3002\u3002\u3002");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u5bf9\u79f0\u89e3\u5bc6\u5f02\u5e38");
            }
        } else if (!StringUtils.isEmpty((Object)resp[5])) {
            resp[0] = (String)resp[0] + "," + (String)resp[5] + "," + (String)resp[4] + "," + (String)resp[2];
        }
        Validate.notBlank((CharSequence)this.getCode(), (String)"\u63a5\u53e3\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull(this.getResponse(), (String)"\u54cd\u5e94\u62a5\u6587\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Class<R> responseType = this.getResponse();
        Validate.notNull(responseType, (String)"responseType\u83b7\u53d6\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            Constructor<R> constructor = responseType.getConstructor(String.class, String.class, CpcnConfig.class);
            response = (TxBaseResponse)constructor.newInstance(resp[0], resp[1], this.cpcnConfig);
            log.info("\u8bf7\u6c42\u4e2d\u91d1\u8fd4\u56de\u53c2\u6570\u4e3a{}", (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6570\u636e\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        Validate.notNull(response, (String)"\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        return (R)response;
    }

    protected String[] send(String requestMessage, String requestSignature, String xml, RequestDgtEnvlp requestDgtEnvlp) {
        String responseText;
        ResponseDgtEnvlp responseDgtEnvlp;
        Object[] response = new String[7];
        String url = this.getRequestUrl();
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NameValuePair message = new NameValuePair("message", requestMessage);
        NameValuePair signature = new NameValuePair("signature", requestSignature);
        if (requestDgtEnvlp != null) {
            NameValuePair isDgEnv = new NameValuePair("isDgEnv", requestDgtEnvlp.getIsDgEnv());
            NameValuePair digitalEnvelope = new NameValuePair("digitalEnvelope", StringUtils.isEmpty((Object)requestDgtEnvlp.getDigitalEnvelope()) ? "" : requestDgtEnvlp.getDigitalEnvelope());
            NameValuePair signAlgorithm = new NameValuePair("signAlgorithm", requestDgtEnvlp.getSignAlgorithm());
            NameValuePair signSN = new NameValuePair("signSN", requestDgtEnvlp.getSignSN());
            NameValuePair encryptSN = new NameValuePair("encryptSN", StringUtils.isEmpty((Object)requestDgtEnvlp.getEncryptSN()) ? "" : requestDgtEnvlp.getEncryptSN());
            NameValuePair institutionID = new NameValuePair("institutionID", requestDgtEnvlp.getInstitutionID());
            list.add(isDgEnv);
            list.add(digitalEnvelope);
            list.add(signAlgorithm);
            list.add(signSN);
            list.add(encryptSN);
            list.add(institutionID);
        }
        list.add(message);
        list.add(signature);
        log.debug("\u8bf7\u6c42\u7684\u5730\u5740=" + url + "]");
        log.debug("message=[" + requestMessage + "]");
        log.debug("signature=[" + requestSignature + "]");
        log.debug(String.format("\u8bf7\u6c42\u4e2d\u91d1\u6570\u636e:[%s],xml\u4e3a:[%s],url:[%s]", requestMessage, xml, url));
        try {
            responseDgtEnvlp = this.httpsConnection.executeRequest(url, list);
            responseText = responseDgtEnvlp.getResponsetext();
        }
        catch (Exception e) {
            log.error(String.format("\u8bf7\u6c42\u4e2d\u91d1\u51fa\u73b0\u9519\u8bef,\u8bf7\u6c42\u6570\u636e\u4e3a%s", xml), (Throwable)e);
            throw new RuntimeException("\u652f\u4ed8\u63a5\u53e3\u8bf7\u6c42\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff01");
        }
        int index = responseText.indexOf(44);
        if (index > 0) {
            response[0] = responseText.substring(0, index);
            response[1] = responseText.substring(index + 1, responseText.length());
            response[2] = responseDgtEnvlp.getIsDgEnv();
            response[3] = responseDgtEnvlp.getDgtlEnvlp();
            response[4] = responseDgtEnvlp.getSignAlgorithm();
            if (responseDgtEnvlp.getSignSN() != null) {
                response[5] = responseDgtEnvlp.getSignSN().toUpperCase();
            }
            if (responseDgtEnvlp.getEncryptSN() != null) {
                response[6] = responseDgtEnvlp.getEncryptSN().toUpperCase();
            }
        } else {
            log.error("\u9519\u8bef\u7684\u8bf7\u6c42\u8fd4\u56de\uff1a{}", (Object)responseText);
            String errorMessage = "\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e";
            throw new RuntimeException(errorMessage);
        }
        log.debug(String.format("\u8bf7\u6c42\u4e2d\u91d1\u8fd4\u56de\u539f\u59cb\u6570\u636e\u4e3a:[%s]", Arrays.toString(response)));
        return response;
    }

    protected String getRequestUrl() {
        CpcnRequestType type = CpcnRequestType.getByCode(this.getCode());
        switch (type.getUrlType()) {
            case PAYMENT_TX: {
                return this.cpcnConfig.getTxUrl();
            }
            case PAYMENT_PAYMENT: {
                return this.cpcnConfig.getPaymentUrl();
            }
            case GATEWAY4FILE: {
                return this.cpcnConfig.getGateway4fileUrl();
            }
            case GATEWAY4AGGREGATE_PAYMENT: {
                return this.cpcnConfig.getGateway4aggregatePaymentUrl();
            }
            case GATEWAY4AGGREGATE_TX: {
                return this.cpcnConfig.getGateway4aggregateTxUrl();
            }
        }
        throw new RuntimeException("\u65e0\u5339\u914d\u7684URL\u5730\u5740\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f");
    }

    public abstract String getCode();

    public abstract Class<R> getResponse();
}

