/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx;

import com.biz.crm.common.pay.support.cpcn.base.common.security.Signer;
import com.biz.crm.common.pay.support.cpcn.base.common.security.Verifier;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;

public abstract class TxBaseRequest {
    private static final Logger log = LoggerFactory.getLogger(TxBaseRequest.class);
    @NotBlank(message="\u4ea4\u6613\u7f16\u7801\u4e0d\u80fd\u8bf6\u7a7a")
    protected @NotBlank(message="\u4ea4\u6613\u7f16\u7801\u4e0d\u80fd\u8bf6\u7a7a") String txCode;
    protected String requestPlainText;
    protected String requestMessage;
    protected String requestSignature;
    protected String signAlgorithm;
    protected String signSN;
    protected String encryptSN;
    protected String dgtlEnvlp;
    protected CpcnConfig cpcnConfig;
    protected Validator validator;

    public abstract void process() throws Exception;

    public void validate() {
        Set violationSet = this.validator.validate((Object)this, new Class[0]);
        if (!CollectionUtils.isEmpty((Collection)violationSet)) {
            throw new IllegalArgumentException(((ConstraintViolation)violationSet.iterator().next()).getMessage());
        }
    }

    protected void postProcess(Document document) throws Exception {
        this.requestPlainText = XmlUtils.createPrettyFormat(document).trim();
        byte[] data = this.requestPlainText.getBytes(StandardCharsets.UTF_8);
        this.requestMessage = new String(Base64Utils.encode((byte[])data));
        Signer signer = this.cpcnConfig.getSigner();
        byte[] signature = signer.sign(data);
        this.requestSignature = PayUtils.bytes2hex(signature);
        if (this.cpcnConfig.getIsDgEnv().booleanValue()) {
            this.signAlgorithm = this.cpcnConfig.getAlgorithm();
            String symmetricCipher = signer.getSymmetricCipher();
            this.signSN = signer.getSN();
            Verifier verifier = this.cpcnConfig.getVerifier();
            this.encryptSN = verifier.getSN();
            this.dgtlEnvlp = "02|" + symmetricCipher;
            try {
                this.requestMessage = verifier.symmetricEncrypt(this.requestPlainText, symmetricCipher);
                this.dgtlEnvlp = verifier.asymmetricEncrypt(this.dgtlEnvlp.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", (Throwable)e);
            }
            log.info("\u6570\u5b57\u4fe1\u5c01\u7ec4\u88c5\u6210\u529f,\u975e\u5bf9\u79f0\u52a0\u5bc6\u516c\u94a5\u5e8f\u5217\u53f7\uff1a" + this.encryptSN);
        }
    }

    public String getTxCode() {
        return this.txCode;
    }

    public String getRequestPlainText() {
        return this.requestPlainText;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public String getSignSN() {
        return this.signSN;
    }

    public String getEncryptSN() {
        return this.encryptSN;
    }

    public String getDgtlEnvlp() {
        return this.dgtlEnvlp;
    }

    public CpcnConfig getCpcnConfig() {
        return this.cpcnConfig;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setTxCode(String txCode) {
        this.txCode = txCode;
    }

    public void setRequestPlainText(String requestPlainText) {
        this.requestPlainText = requestPlainText;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    public void setRequestSignature(String requestSignature) {
        this.requestSignature = requestSignature;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public void setSignSN(String signSN) {
        this.signSN = signSN;
    }

    public void setEncryptSN(String encryptSN) {
        this.encryptSN = encryptSN;
    }

    public void setDgtlEnvlp(String dgtlEnvlp) {
        this.dgtlEnvlp = dgtlEnvlp;
    }

    public void setCpcnConfig(CpcnConfig cpcnConfig) {
        this.cpcnConfig = cpcnConfig;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String toString() {
        return "TxBaseRequest(txCode=" + this.getTxCode() + ", requestPlainText=" + this.getRequestPlainText() + ", requestMessage=" + this.getRequestMessage() + ", requestSignature=" + this.getRequestSignature() + ", signAlgorithm=" + this.getSignAlgorithm() + ", signSN=" + this.getSignSN() + ", encryptSN=" + this.getEncryptSN() + ", dgtlEnvlp=" + this.getDgtlEnvlp() + ", cpcnConfig=" + this.getCpcnConfig() + ", validator=" + this.getValidator() + ")";
    }
}

