package com.biz.crm.common.pay.support.sdk.vo;

import lombok.Data;

/**
 * 付款账户
 *
 * @author hefan
 * @date 2022/08/09
 */
@Data
public class PaymentAccountSupportVo {
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 归属父级用户 ID
   */
  private String parentUserID;
  /**
   * 可用账户余额
   * <p>
   * 注:单位:分
   */
  private String balance;
  /**
   * 到账余额
   */
  private String receivedBalance;
  /**
   * 在途余额
   */
  private String receivableBalance;
  /**
   * 冻结账户余额
   */
  private String frozenAmount;
  /**
   * 用户类型:
   * <p>
   * 10=个人用户
   * 15=个体工商户用户
   * 20=企业用户
   * 40=匿名用户
   */
  private String userType;
  /**
   * 账户状态:
   * <p>
   * 10=正常
   * 30=冻结
   * 35=止付
   */
  private String status;

  /**
   * 账户名称
   * 账户编码
   * 账户类型
   * 企业名称
   * 企业邮箱
   * 企业类型
   * 区域
   * 企业规模
   * 统一社会信用代码
   * 开户许可证核准号
   * 对公账户
   * 法人姓名
   * 法人身份证号
   * 法人手机号
   * 法人邮箱
   */
}
