package com.biz.crm.common.pay.support.sdk.vo.transfer.notice;

import lombok.Data;

/**
 * 转账的notice vo
 *
 * @author hefan
 * @date 2022/08/26
 */
@Data
public abstract class TransferVo {
  /**
   * 交易流水号
   *
   * 格式:只能为数字字 母 开头和结尾, 中间 可以包含 -
   */
  private String txSN;

  /**
   * 业务订单号
   */
  private String orderNo;

  /**
   * 收款用户帐号
   */
  private String payeeAccountNumber;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 支付金额
   * 单位:分
   */
  private String amount;
  /**
   * 支付回单流水号
   */
  private String bankTraceNo;
  /**
   * 失效时间
   */
  private String expireTime;
  /**
   * 实际支付银行卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 30=贷记卡
   * 40=其他
   */
  private String actualCardType;
  /**
   * 响应时间
   */
  private String responseTime;

}
