package com.biz.crm.common.pay.support.sdk.dto.transfer;

import lombok.Data;

/**
 * 支付转账
 *
 * @author hefan
 * @date 2022/08/25
 */
@Data
public abstract class TransferDto {
  /**
   * 交易流水号
   *
   * 格式:只能为数字字 母 开头和结尾, 中间 可以包含 -
   */
  private String txSN;

  /**
   * 业务订单号
   */
  private String orderNo;

  /**
   * 付款用户 ID
   */
  private String payerUserID;
  /**
   * 收款用户帐号
   */
  private String payeeAccountNumber;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 支付金额
   * 单位:分
   */
  private String amount;
  /**
   * 交易失效时间
   */
  private String expirePeriod;
  /**
   * 备注
   */
  private String remark;

}
