package com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier;

import com.biz.crm.common.pay.support.sdk.dto.transfer.TransferDto;

/**
 * 转账-载体
 *
 * @author hefan
 * @date 2022/08/25
 */
public interface TransferCarrier<V> {

  /**
   * 得到转账数据
   *
   * @return {@link TransferDto}
   */
  TransferDto getTransferData();

  /**
   * 载体对应的vo
   * - 该vo接受的返回数据
   *
   * @param response 响应
   * @return {@link V}
   */
  default V getVo(Object response) {
    return  (V)response;
  }


}
