package com.biz.crm.common.pay.support.sdk.vo;

import lombok.Data;

/**
 * 帐户余额
 *
 * @author hefan
 * @date 2022/08/15
 */
@Data
public class AccountBalanceSupportVo {
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 归属父级用户 ID
   */
  private String parentUserID;
  /**
   * 可用账户余额
   * <p>
   * 注:单位:分
   */
  private String balance;
  /**
   * 到账余额
   */
  private String receivedBalance;
  /**
   * 在途余额
   */
  private String receivableBalance;
  /**
   * 冻结账户余额
   */
  private String frozenAmount;
  /**
   * 用户类型:
   * <p>
   * 10=个人用户
   * 15=个体工商户用户
   * 20=企业用户
   * 40=匿名用户
   */
  private String userType;
  /**
   * 账户状态:
   * <p>
   * 10=正常
   * 30=冻结
   * 35=止付
   */
  private String status;


}
