package com.biz.crm.common.pay.support.sdk.vo;

import lombok.Data;

/**
 * 银行卡支持签证官
 *
 * @author hefan
 * @date 2022/08/10
 */
@Data
public class BankAccountSupportVo {

  /**
   * 银行账户绑定流水号
   */
  private String bindingTxSN;
  /**
   * 开户行 ID
   * - 注：参考《银行编码表》
   */
  private String bankID;
  /**
   * 账户类型：
   * 11=个人账户
   * 12=企业账户
   */
  private String bankAccountType;
  /**
   * 账户名称
   */
  private String bankAccountName;
  /**
   * 账户号码
   * - 注：只返回账号的最后 4 位数字
   */
  private String bankAccountNumber;
  /**
   * 分支行名称
   */
  private String branchName;
  /**
   * 银行卡预留手机号码
   * - 注：只返回后 4 位
   */
  private String bankPhoneNumber;
  /**
   * 绑定卡类型：
   * 10=快捷卡
   * 20=提现卡
   */
  private String cardBusinessType;
  /**
   * 线下转账充值开通标识：
   * 10=未开通
   * 20=已开通
   * 30=已取消
   */
  private String transferChargeFlag;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 收款用户姓名
   */
  private String payeeUserName;
}
