package com.biz.crm.common.personalized.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.personalized.local.entity.ScreenButton;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * @author XXLsansui
 * @date 2023-02-13 16:35
 * @description：列表模板-常用筛选服务接口
 */
public interface ScreenButtonService {

  /**
   * 查询当前用户常用筛选字段模板
   * @param pageable
   * @param screenButton
   * @return
   */
  Page<ScreenButton> findByConditions(Pageable pageable, ScreenButton screenButton);

  /**
   * 新建配置
   * @param screenButton 配置实体
   * @return 新建后的实体类
   */
  ScreenButton create(ScreenButton screenButton);

  /**
   * 更新配置
   * @param screenButton 配置实体
   * @return 更新后的实体类
   */
  ScreenButton update(ScreenButton screenButton);

  /**
   * 批量删除
   * @param ids 主键列表
   */
  void deleteBatch(List<String> ids);
}
