/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.personalized.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.personalized.local.entity.ScreenButton;
import com.biz.crm.common.personalized.local.repository.ScreenButtonRepository;
import com.biz.crm.common.personalized.local.service.ScreenButtonService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="screenButtonService")
public class ScreenButtonServiceImpl
implements ScreenButtonService {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ScreenButtonRepository screenButtonRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<ScreenButton> findByConditions(Pageable pageable, ScreenButton screenButton) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        screenButton = Optional.ofNullable(screenButton).orElse(new ScreenButton());
        screenButton.setCurrentAccount(this.loginUserService.getLoginAccountName());
        screenButton.setTenantCode(TenantUtils.getTenantCode());
        screenButton.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        screenButton.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ScreenButton> result = this.screenButtonRepository.findByConditions((Page<ScreenButton>)page, screenButton);
        return result;
    }

    @Override
    @Transactional
    public ScreenButton create(ScreenButton screenButton) {
        this.checkData(screenButton);
        String screenButtonCode = (String)this.generateCodeService.generateCode("SBC", 1).get(0);
        screenButton.setScreenButtonCode(screenButtonCode);
        screenButton.setCurrentAccount(this.loginUserService.getLoginAccountName());
        screenButton.setTenantCode(TenantUtils.getTenantCode());
        screenButton.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        screenButton.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        screenButton.setCreateName(this.loginUserService.getLoginAccountName());
        screenButton.setCreateTime(new Date());
        if (screenButton.getIsDefault().booleanValue()) {
            this.updateDefault(screenButton);
        }
        this.screenButtonRepository.saveOrUpdate((Object)screenButton);
        return screenButton;
    }

    @Override
    @Transactional
    public ScreenButton update(ScreenButton screenButton) {
        this.checkData(screenButton);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)screenButton.getScreenButtonCode()) ? 1 : 0) != 0, (String)"\u5e38\u7528\u7b5b\u9009\u6a21\u677f\u7f16\u7801\u7f3a\u5931", (Object[])new Object[0]);
        ScreenButton screenButtonOld = (ScreenButton)((Object)this.screenButtonRepository.getById((Serializable)((Object)screenButton.getId())));
        screenButtonOld.setScreenButtonName(screenButton.getScreenButtonName());
        screenButtonOld.setIsDefault(screenButton.getIsDefault());
        screenButtonOld.setDataJson(screenButton.getDataJson());
        screenButtonOld.setModifyName(this.loginUserService.getLoginAccountName());
        screenButtonOld.setModifyTime(new Date());
        if (screenButton.getIsDefault().booleanValue()) {
            this.updateDefault(screenButton);
        }
        this.screenButtonRepository.saveOrUpdate((Object)screenButtonOld);
        return screenButtonOld;
    }

    public void updateDefault(ScreenButton screenButton) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.screenButtonRepository.lambdaUpdate().set(ScreenButton::getIsDefault, (Object)false)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ScreenButton::getCurrentAccount, (Object)this.loginUserService.getLoginAccountName())).eq(ScreenButton::getDataView, (Object)screenButton.getDataView())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).update();
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.screenButtonRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void checkData(ScreenButton screenButton) {
        Validate.isTrue((!ObjectUtils.isEmpty((Object)screenButton.getScreenButtonName()) ? 1 : 0) != 0, (String)"\u8bf7\u586b\u5199\u7b5b\u9009\u6a21\u677f\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)screenButton.getDataJson()) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u7b5b\u9009\u5b57\u6bb5", (Object[])new Object[0]);
    }
}

