package com.biz.crm.common.personalized.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * @author XXLsansui
 * @date 2023-02-13 16:06
 * @description：
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("screen_button")
@ApiModel(value = "ScreenButton", description = "常用筛选")
public class ScreenButton extends TenantFlagOpEntity {

  private static final long serialVersionUID = 1L;

  /**
   * 当前用户
   */
  @ApiModelProperty("当前用户")
  @TableField(value = "current_account")
  @Column(name = "current_account", length = 64, columnDefinition = "varchar(64) COMMENT '当前用户'")
  private String currentAccount;

  /**
   *   数据视图标识
   */
  @ApiModelProperty("数据视图标识")
  @TableField(value = "data_view")
  @Column(name = "data_view", length = 255, columnDefinition = "varchar(255) COMMENT '数据视图标识'")
  private String dataView;

  /**
   * 是否默认
   */
  @ApiModelProperty("是否默认")
  @TableField(value = "is_default")
  private Boolean isDefault = false;

  /**
   * 常用筛选编码
   */
  @ApiModelProperty(value = "常用筛选编码")
  @TableField(value = "screen_button_code")
  @Column(name = "screen_button_code", length = 128, columnDefinition = "varchar(128) COMMENT '常用筛选编码'")
  private String screenButtonCode;

  /**
   * 常用筛选名称
   */
  @ApiModelProperty(value = "常用筛选名称")
  @TableField(value = "screen_button_name")
  @Column(name = "screen_button_name", length = 128, columnDefinition = "varchar(128) COMMENT '常用筛选名称'")
  private String screenButtonName;

  /**
   * 数据json
   */
  @ApiModelProperty(value = "数据json")
  @TableField(value = "data_json")
  @Column(name = "data_json", columnDefinition = "text COMMENT '数据json'")
  private String dataJson;





}
