package com.biz.crm.common.personalized.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author XXLsansui
 * @date 2023-02-14 18:15
 * @description：个性化功能收藏夹菜单
 */
@Data
@ApiModel(value = "PersonalizedFavoritesVo",description = "个性化功能收藏夹菜单新增dto")
public class PersonalizedFavoritesVo extends TenantFlagOpDto {

  @ApiModelProperty("当前用户")
  private String currentAccount;

  /**
   * 菜单编码集合，新增时传入所有菜单元素，删除时传入一个欲删除的菜单元素
   */
  @ApiModelProperty("菜单编码集合，新增时传入所有菜单元素，删除时传入一个欲删除的菜单元素")
  List<String> competenceCodes;
}
