package com.biz.crm.common.rulecode.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author XXLsansui
 * @date 2024-01-24 10:14
 * @description：编码规则Vo
 */
@Data
@ApiModel(value = "GenerateCodeRuleVo",description = "编码规则Vo")
public class GenerateCodeRuleVo extends TenantFlagOpVo {

  /**
   * 业务key
   */
  @ApiModelProperty("业务key")
  private String ruleCode;

  /**
   * 前缀
   */
  @ApiModelProperty("前缀")
  private String prefix;

  /**
   * 时间戳格式
   */
  @ApiModelProperty("时间戳格式")
  private String dateFormat;

  /**
   * 编码总长度
   */
  @ApiModelProperty("编码总长度")
  private Integer codeLength;

  /**
   * 规则描述
   */
  @ApiModelProperty("规则描述")
  private String ruleDescription;

  /**
   * 起始值
   */
  @ApiModelProperty("起始值")
  private Long initialValue;

  /**
   * 当前值
   */
  @ApiModelProperty("当前值")
  private Long currentValue;

  @ApiModelProperty("生成时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date generateDate;

  /**
   * 所属模块
   */
  @ApiModelProperty("所属模块")
  private String ruleModule;

}
