package com.biz.crm.common.verification.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.ramostear.captcha.HappyCaptcha;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 图形验证码通用接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("/v1/verification/image")
@Api(tags = "图形验证码通用接口")
public class VerificationController {

  @ApiOperation(value = "获取图形验证码")
  @GetMapping("/getVerificationImage")
  public void sendLoginSmsCode(HttpServletRequest request, HttpServletResponse response) {
    HappyCaptcha.require(request, response).build().finish();
  }

  @GetMapping("/verifyVerificationImage")
  @ApiModelProperty(value = "验证图形验证码")
  public Result<?> verify(String code, HttpServletRequest request) {
    boolean flag = HappyCaptcha.verification(request, code, true);
    if (flag) {
      HappyCaptcha.remove(request);
      return Result.ok("验证成功");
    } else {
      return Result.error("验证码不正确");
    }
  }


}
