/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.verification.slider.controller;

import cn.hutool.core.io.resource.ResourceUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.verification.slider.core.CaptchaResult;
import com.biz.crm.common.verification.slider.core.CaptchaVo;
import com.biz.crm.common.verification.slider.core.PuzzleCaptcha;
import com.biz.crm.common.verification.slider.util.CaptchaUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/verification/slider"})
@Api(tags={"\u6ed1\u5757\u9a8c\u8bc1\u7801\u901a\u7528\u63a5\u53e3"})
public class VerificationSliderController {
    private static final Logger log = LoggerFactory.getLogger(VerificationSliderController.class);
    private static final String path = "/opt/sliderImages";
    @Value(value="${slider.imagePath}")
    private String imagesPath;
    @Autowired
    private CaptchaUtil captchaUtil;

    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getVerificationSlider"})
    public Result<CaptchaVo> captcha() {
        try {
            PuzzleCaptcha puzzleCaptcha;
            if (StringUtils.isBlank((CharSequence)this.imagesPath)) {
                this.imagesPath = path;
            }
            File file = new File(this.imagesPath);
            ArrayList files = Lists.newArrayList();
            this.findFile(files, file);
            if (CollectionUtils.isEmpty((Collection)files)) {
                puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream((String)"images/defaultImage.webp"));
            } else {
                int length = new Random().nextInt(files.size());
                puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream((String)((File)files.get(length)).getAbsolutePath()));
            }
            puzzleCaptcha.setImageQuality(16);
            puzzleCaptcha.run();
            return Result.ok((Object)this.captchaUtil.captcha(puzzleCaptcha));
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6ed1\u5757\u5f02\u5e38", (Throwable)e);
            return Result.error((String)"\u751f\u6210\u6ed1\u5757\u9a8c\u8bc1\u56fe\u7247\u5931\u8d25\uff01");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/verifyVerificationSlider"})
    public Result<CaptchaResult> verify(@RequestBody Map<String, Object> map) {
        return Result.ok((Object)this.captchaUtil.verify(map));
    }

    private void findFile(List<File> files, File file) {
        File[] fs = file.listFiles();
        if (fs != null && fs.length > 0) {
            for (File f : fs) {
                if (f.isDirectory()) {
                    this.findFile(files, f);
                    continue;
                }
                if (!f.isFile()) continue;
                files.add(f);
            }
        }
    }
}

