/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.verification.slider.exception;

import com.biz.crm.common.verification.slider.exception.ErrorMessage;
import com.biz.crm.common.verification.slider.exception.ServerException;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class AppExceptionHandler {
    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage handleValidationException(ConstraintViolationException e) {
        Iterator iterator = e.getConstraintViolations().iterator();
        if (iterator.hasNext()) {
            ConstraintViolation s = (ConstraintViolation)iterator.next();
            return new ErrorMessage("E0001", s.getMessage());
        }
        return new ErrorMessage("E0001", "\u9519\u8bef\u7684\u8bf7\u6c42\u53c2\u6570");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage handleValidationBodyException(MethodArgumentNotValidException e) {
        Iterator iterator = e.getBindingResult().getAllErrors().iterator();
        if (iterator.hasNext()) {
            ObjectError s = (ObjectError)iterator.next();
            return new ErrorMessage("E0001", s.getDefaultMessage());
        }
        return new ErrorMessage("E0001", "\u9519\u8bef\u7684\u8bf7\u6c42\u53c2\u6570");
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage handleValidationBeanException(BindException e) {
        Iterator iterator = e.getAllErrors().iterator();
        if (iterator.hasNext()) {
            ObjectError s = (ObjectError)iterator.next();
            return new ErrorMessage("E0001", s.getDefaultMessage());
        }
        return new ErrorMessage("E0001", "\u9519\u8bef\u7684\u8bf7\u6c42\u53c2\u6570");
    }

    @ExceptionHandler(value={ServerException.class})
    public ErrorMessage handleServiceException(ServerException e, HttpServletResponse response) {
        response.setStatus(e.getStatusCode().value());
        Object data = e.getData();
        if (data == null) {
            return new ErrorMessage(e.getCode(), e.getMessage());
        }
        return new ErrorMessage(e.getCode(), e.getMessage(), data);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ErrorMessage handleUnProcessableServiceException(IllegalArgumentException e, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return new ErrorMessage("E0001", e.getMessage());
    }

    @ExceptionHandler(value={ConversionFailedException.class})
    public ErrorMessage parseException(ConversionFailedException e, HttpServletResponse response) {
        String message = e.getMessage();
        if (e.getCause() instanceof IllegalArgumentException) {
            message = e.getCause().getMessage();
        }
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return new ErrorMessage("E0001", message);
    }
}

