package com.biz.crm.common.weixinsign.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.weixinsign.sdk.service.WXCacheVoService;
import com.biz.crm.common.weixinsign.sdk.vo.WxCacheVo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * @author hecheng
 * @description: 微信 缓存
 * @date 2021/9/8 下午8:31
 */
public class RedisWXCacheVoServiceImpl implements WXCacheVoService {


  private RedisTemplate redisTemplate;

  public RedisWXCacheVoServiceImpl(RedisTemplate redisTemplate) {
    this.redisTemplate = redisTemplate;
  }


  @Override
  public String get(String key) {
    String jsonStr = (String) this.redisTemplate.opsForValue().get(key);
    if (StringUtils.isNotBlank(jsonStr)) {
      try {
        WxCacheVo wxCacheVo = JSONObject.parseObject(jsonStr, WxCacheVo.class);
        return wxCacheVo.getValue();
      } catch (Exception e) {
        return null;
      }
    }
    return null;
  }


  @Override
  public void set(String key, String jsonValue) {
    WxCacheVo wxCacheVo = JSONObject.parseObject(jsonValue, WxCacheVo.class);
    this.redisTemplate.opsForValue().set(key, jsonValue, wxCacheVo.getExpiresIn(), TimeUnit.SECONDS);
  }

  @Override
  public void set(String key, String jsonValue, long expiresIn) {
    this.redisTemplate.opsForValue().set(key, jsonValue, expiresIn, TimeUnit.SECONDS);
  }

  @Override
  public void remove(String key) {
    this.redisTemplate.expire(key, 0, TimeUnit.SECONDS);
  }
}
