package com.biz.crm.common.weixinsign.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.weixinsign.local.config.WxAppletConfigTest;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.common.weixinsign.sdk.vo.OpenIdVo;
import com.biz.crm.common.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;

/**
 * 微信http接口
 *
 * @author hecheng
 */
@Slf4j
@RestController
@RequestMapping("/v1/wx/wxOpen")
@Api(tags = "微信http接口")
public class WXOpenController extends WxBaseController {

  @Autowired
  private WXOpenVoService wxOpenService;
  @Autowired
  private WxAppletConfigTest wxAppletConfigTest;

  /**
   * 获取全局jssdk配置
   *
   * @param url
   * @param appType
   * @return
   */
  @ApiOperation(value = "获取全局jssdk配置")
  @GetMapping("/findWXJsConfig")
  public Result<WXJsConfigVo> findWXJsConfig(@ApiParam("签名url") String url, @ApiParam("应用类型") @RequestParam(required = false) String appType, @RequestParam(required = false) Boolean isUrlEncoder) {
    try {
      if (Objects.nonNull(isUrlEncoder) && isUrlEncoder && StringUtils.isNotBlank(url)) {
        try {
          url = URLDecoder.decode(url, "utf-8");
        } catch (UnsupportedEncodingException e) {
          throw new IllegalArgumentException("url不能为空！");
        }
      }
      WXJsConfigVo value = this.wxOpenService.findWXJsConfig(url, appType);
      return Result.ok(value);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取全局token配置
   *
   * @param appType
   * @return
   */
  @ApiOperation(value = "获取全局token配置")
  @GetMapping("/findAccessTokenByAppType")
  public Result<String> findAccessTokenByAppType(@RequestParam(required = false) @ApiParam("应用类型") String appType) {
    try {
      String value = this.wxOpenService.findAccessToken(appType);
      Result result = Result.ok("");
      result.setResult(value);
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取JsApiTicket配置
   *
   * @param appType
   * @return
   */
  @ApiOperation(value = "获取JsApiTicket配置")
  @GetMapping("/findJsApiTicketByAppType")
  public Result<String> findJsApiTicketByAppType(@RequestParam(required = false) @ApiParam("应用类型") String appType) {
    try {
      String value = this.wxOpenService.findJsApiTicket(appType);
      Result result = Result.ok("");
      result.setResult(value);
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取微信网页授权code
   *
   * @param code
   * @param code
   * @return
   */
  @ApiOperation(value = "获取微信网页授权accessToken")
  @GetMapping("/findWebViewAccessToken")
  public Result<WxWebViewAccessTokenRespVo> findWebViewAccessToken(@ApiParam("code") @RequestParam String code,
          @ApiParam("应用类型") @RequestParam(required = false) String appType) {
    try {
      WxWebViewAccessTokenRespVo accessTokenRespVo = wxOpenService.findWebViewAccessToken(code, appType);
      return Result.ok(accessTokenRespVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过checkCode获取openid")
  @GetMapping("findByCheckCode")
  public Result<OpenIdVo> findByCheckCode(@ApiParam(name = "checkCode", value = "凭证") String checkCode) {
    try {
      if (StringUtils.isBlank(checkCode)) {
        return Result.ok(new OpenIdVo());
      }
      OpenIdVo appletOpenId = this.wxAppletConfigTest.getAppletOpenId(checkCode);
      return Result.ok(appletOpenId);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
