package com.biz.crm.common.weixinsign.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @author hecheng
 * @Description: 微信授权变更类型
 **/
public enum WXAuthorizationChangeTypeEnum {
  /**
   * 取消授权
   */
  UNAUTHORIZED("unauthorized", "取消授权"),
  /**
   * 更新授权
   */
  UPDATEAUTHORIZED("updateauthorized", "更新授权"),
  /**
   * 授权成功
   */
  AUTHORIZED("authorized", "授权成功"),
  ;

  private String code;
  private String des;

  WXAuthorizationChangeTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   *
   * @return
   */
  public static Set<String> codeToSet() {
    Set<String> codes = new HashSet<>();
    for (WXAuthorizationChangeTypeEnum enableStatusEnum : WXAuthorizationChangeTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   *
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      WXAuthorizationChangeTypeEnum[] values = WXAuthorizationChangeTypeEnum.values();
      for (WXAuthorizationChangeTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   *
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    WXAuthorizationChangeTypeEnum[] values = WXAuthorizationChangeTypeEnum.values();
    for (WXAuthorizationChangeTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

