package com.biz.crm.common.weixinsign.sdk.service;

import com.biz.crm.common.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxUserInfoVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;

/**
 * 微信公众号 接口
 *
 * @author hecheng
 */
public interface WXOpenVoService {

  /**
   * 获取微信公众号全局Access token
   *
   * @param appType 应用类型
   * @return
   */
  String findAccessToken(String appType);

  /**
   * 获取微信公众号JSAPI_TICKET
   *
   * @param appType 应用类型
   * @return
   */
  String findJsApiTicket(String appType);

  /**
   * 获取微信公众号jssdk 调用配置
   *
   * @param appType 应用类型
   * @param url
   * @return
   */
  WXJsConfigVo findWXJsConfig(String url, String appType);

  /**
   * 获取微信网页授权code
   *
   * @param redirectUri
   * @param scope
   * @param appType
   * @return
   */
  String getAuthorizeUrl(String redirectUri, String scope, String appType);

  /**
   * 微信网页授权token
   *
   * @param code
   * @param appType
   * @return
   */
  WxWebViewAccessTokenRespVo findWebViewAccessToken(String code, String appType);

  /**
   * 获取微信用户信息
   *
   * @param openId 用户的唯一标识
   * @param accessToken 网页授权接口调用凭证,注意：此access_token与基础支持的access_token不同
   * @param lang 返回国家地区语言版本，zh_CN 简体，zh_TW 繁体，en 英语
   * @return
   */
  WxUserInfoVo findWxUserInfo(String openId, String accessToken, String lang);
}
