package com.biz.crm.common.weixinsign.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @author hecheng
 * @Description: 微信平台类型
 **/
public enum WXPlatformTypeEnum {
  /**
   * 微信公众号
   */
  OFFICIAL_ACCOUNT("h5", "微信公众号"),
  /**
   * 微信小程序
   */
  MINI_PROGRAM("weapp", "微信小程序");

  private String code;
  private String des;

  WXPlatformTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   *
   * @return
   */
  public static Set<String> codeToSet() {
    Set<String> codes = new HashSet<>();
    for (WXPlatformTypeEnum enableStatusEnum : WXPlatformTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   *
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      WXPlatformTypeEnum[] values = WXPlatformTypeEnum.values();
      for (WXPlatformTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   *
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    WXPlatformTypeEnum[] values = WXPlatformTypeEnum.values();
    for (WXPlatformTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

