package com.biz.crm.common.weixinsign.sdk.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 微信第三方平台接口的调用凭据
 * @date 2021/9/8 下午3:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WxComponentAccessTokenRespVo", description = "微信第三方平台接口的调用凭据  vo")
public class WxComponentAccessTokenRespVo extends WXErrVo {

  /**
   * 第三方平台 access_token
   */
  @ApiModelProperty("第三方平台 access_token")
  @JsonProperty("component_access_token")
  private String componentAccessToken;
  /**
   * 凭证有效时间，单位：秒s
   */
  @ApiModelProperty("凭证有效时间，单位：秒")
  @JsonProperty("expires_in")
  private long expiresIn;
}
