/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.common.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.biz.crm.cpcnpay.common.security.Verifier;
import com.biz.crm.cpcnpay.common.utils.PayUtils;
import com.biz.crm.cpcnpay.common.utils.SM4Utils;
import java.nio.charset.StandardCharsets;
import java.security.Key;

public class SMVerifier
implements Verifier {
    private static final Mechanism mechanism = new Mechanism("SM2");
    private static Session session;
    private X509Cert x509Cert;

    public SMVerifier(X509Cert x509Cert) throws Exception {
        this.x509Cert = x509Cert;
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        session = JCrypto.getInstance().openSession("JSOFT_LIB");
    }

    @Override
    public boolean verify(String message, String signature) throws Exception {
        return this.verify(message.getBytes(StandardCharsets.UTF_8), PayUtils.hex2bytes(signature));
    }

    @Override
    public boolean verify(byte[] message, byte[] signature) throws Exception {
        Signature sig = new Signature();
        return sig.p7VerifyMessageDetach(message, signature, session);
    }

    @Override
    public String symmetricEncrypt(String message, String symmetricCipher) throws Exception {
        return SM4Utils.encrypt(message, symmetricCipher);
    }

    @Override
    public String getSN() {
        return String.valueOf(this.x509Cert.getStringSerialNumber());
    }

    @Override
    public String asymmetricEncrypt(byte[] message) throws Exception {
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)this.x509Cert.getPublicKey(), (byte[])message, (Session)session);
        return new String(base64Bytes, StandardCharsets.UTF_8);
    }
}

