/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.tx;

import com.biz.crm.cpcnpay.common.utils.PayUtils;
import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;

public abstract class TxBaseRequest {
    @NotBlank(message="\u4ea4\u6613\u7f16\u7801\u4e0d\u80fd\u8bf6\u7a7a")
    protected @NotBlank(message="\u4ea4\u6613\u7f16\u7801\u4e0d\u80fd\u8bf6\u7a7a") String txCode;
    protected String requestPlainText;
    protected String requestMessage;
    protected String requestSignature;
    protected String signAlgorithm;
    protected String signSN;
    protected String encryptSN;
    protected String dgtlEnvlp;
    protected CpcnConfig cpcnConfig;
    protected Validator validator;

    public abstract void process() throws Exception;

    public void validate() {
        Set violationSet = this.validator.validate((Object)this, new Class[0]);
        if (!CollectionUtils.isEmpty((Collection)violationSet)) {
            throw new IllegalArgumentException(((ConstraintViolation)violationSet.iterator().next()).getMessage());
        }
    }

    protected void postProcess(Document document) throws Exception {
        this.requestPlainText = XmlUtils.createPrettyFormat(document).trim();
        byte[] data = this.requestPlainText.getBytes(StandardCharsets.UTF_8);
        this.requestMessage = new String(Base64Utils.encode((byte[])data));
        byte[] signature = this.cpcnConfig.getSigner().sign(data);
        this.requestSignature = PayUtils.bytes2hex(signature);
    }

    public String getTxCode() {
        return this.txCode;
    }

    public String getRequestPlainText() {
        return this.requestPlainText;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public String getSignSN() {
        return this.signSN;
    }

    public String getEncryptSN() {
        return this.encryptSN;
    }

    public String getDgtlEnvlp() {
        return this.dgtlEnvlp;
    }

    public CpcnConfig getCpcnConfig() {
        return this.cpcnConfig;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setTxCode(String txCode) {
        this.txCode = txCode;
    }

    public void setRequestPlainText(String requestPlainText) {
        this.requestPlainText = requestPlainText;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    public void setRequestSignature(String requestSignature) {
        this.requestSignature = requestSignature;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public void setSignSN(String signSN) {
        this.signSN = signSN;
    }

    public void setEncryptSN(String encryptSN) {
        this.encryptSN = encryptSN;
    }

    public void setDgtlEnvlp(String dgtlEnvlp) {
        this.dgtlEnvlp = dgtlEnvlp;
    }

    public void setCpcnConfig(CpcnConfig cpcnConfig) {
        this.cpcnConfig = cpcnConfig;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String toString() {
        return "TxBaseRequest(txCode=" + this.getTxCode() + ", requestPlainText=" + this.getRequestPlainText() + ", requestMessage=" + this.getRequestMessage() + ", requestSignature=" + this.getRequestSignature() + ", signAlgorithm=" + this.getSignAlgorithm() + ", signSN=" + this.getSignSN() + ", encryptSN=" + this.getEncryptSN() + ", dgtlEnvlp=" + this.getDgtlEnvlp() + ", cpcnConfig=" + this.getCpcnConfig() + ", validator=" + this.getValidator() + ")";
    }
}

