package com.biz.crm.cpcnpay.common.security;

/**
 * 签名方法接口
 *
 * @author Keller
 */
public interface Signer {

  /**
   * 签名采用默认算法(SHA1withRSA)
   *
   * @param message
   * @return
   */
  String sign(String message) throws Exception;

  /**
   * 签名指定算法
   *
   * @param data
   * @param algorithm
   * @return
   */
  byte[] sign(byte[] data, String algorithm) throws Exception;

  /**
   * 签名采用默认算法(SHA1withRSA)
   *
   * @param data
   * @return
   */
  byte[] sign(byte[] data) throws Exception;

  /**
   * 制定的算法进行信息解密
   *
   * @param message
   * @param digitalEnvelope
   * @return
   * @throws Exception
   */
  String decrypt(String message, String digitalEnvelope) throws Exception;

  /**
   * 默认算法进行信息解密
   *
   * @param message
   * @return
   * @throws Exception
   */
  String decrypt(String message) throws Exception;

  /**
   * 获取序列号
   *
   * @return
   */
  String getSN();

  /**
   * 对称加密秘钥
   * @return
   */
  String getSymmetricCipher();

  /**
   * 加密算法
   *
   * @return
   */
  String getAlgorithm();
}
