package com.biz.crm.cpcnpay.common.utils;

import cfca.sadk.util.EncryptUtil;

import java.nio.charset.StandardCharsets;

/**
 * SM4 加密工具类
 *
 * @author Keller
 */
public final class SM4Utils {

  private SM4Utils() {
    throw new UnsupportedOperationException("静态工具类，不支持实例化");
  }

  public static String encrypt(String plainText, String key) throws Exception {
    return encrypt(plainText.getBytes(), key);
  }

  public static String encrypt(byte[] plainText, String key) throws Exception {
    return new String(EncryptUtil.encryptMessageBySM4(plainText, key), StandardCharsets.UTF_8);
  }

  public static String decrypt(String cipherText, String key) throws Exception {
    return decrypt(cipherText.getBytes(), key);
  }

  public static String decrypt(byte[] cipherText, String key) throws Exception {
    return new String(EncryptUtil.decryptMessageBySM4(cipherText, key), StandardCharsets.UTF_8);
  }
}
