package com.biz.crm.cpcnpay.core.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 响应类型
 *
 * @author Keller
 */
@Getter
@AllArgsConstructor
public enum CpcnNoticeType {
  /**
   * 7709-壹企付用户签约成功后台通知
   */
  NOTICE_7709("7709", "7709-壹企付用户签约成功后台通知"),
  /**
   * 2736-商户进件状态变更通知
   */
  NOTICE_2736("2736", "2736-商户进件状态变更通知"),
  /**
   * 4618-开户/绑卡结果通知
   */
  NOTICE_4618("4618", "4618-开户/绑卡结果通知"),
  /**
   * 4658-充值/提现/代付结果通知
   */
  NOTICE_4658("4658", "4658-充值/提现/代付结果通知"),
  /**
   * 4668-白名单开通/注销通知
   */
  NOTICE_4668("4668", "4668-白名单开通/注销通知"),
  /**
   * 5018-支付通知
   */
  NOTICE_5018("5018", "5018-支付通知"),
  /**
   * 5028-退款结果通知
   */
  NOTICE_5028("5028", "5028-退款结果通知"),

  /**
   * 5038-分账结果通知
   */
  NOTICE_5038("5038","5038-延迟分账结果通知");

  /**
   * code
   */
  private final String code;

  /**
   * 描述
   */
  private final String desc;

}
