package com.biz.crm.cpcnpay.core.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付请求类型
 *
 * @author Keller
 */
@Getter
@AllArgsConstructor
public enum CpcnRequestType {
  /**
   * 7703-壹企付用户签约入网
   */
  TX_7703_REQUEST("7703", "7703-壹企付用户签约入网", CpcnUrlType.PAYMENT_TX),
  /**
   * 7704-壹企付用户签约状态查询
   */
  TX_7704_REQUEST("7704", "7704-壹企付用户签约状态查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 2734-商户进件
   */
  TX_2734_REQUEST("2734", "2734-商户进件", CpcnUrlType.PAYMENT_TX),
  /**
   * 2735-商户进件状态查询
   */
  TX_2735_REQUEST("2735", "2735-商户进件状态查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 2751-卡 bin 信息查询
   */
  TX_2751_REQUEST("2751", "2751-卡 bin 信息查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 1850-对账文件下载
   */
  TX_1850_REQUEST("1850", "1850-对账文件下载", CpcnUrlType.GATEWAY4FILE),
  /**
   * 4600-影印件采集
   */
  TX_4600_REQUEST("4600", "4600-影印件采集", CpcnUrlType.GATEWAY4FILE),
  /**
   * 4601-开户
   */
  TX_4601_REQUEST("4601", "4601-开户", CpcnUrlType.PAYMENT_TX),
  /**
   * 4611-绑卡
   */
  TX_4611_REQUEST("4611", "4611-绑卡", CpcnUrlType.PAYMENT_TX),
  /**
   * 4613-绑卡确认
   */
  TX_4613_REQUEST("4613", "4613-绑卡确认", CpcnUrlType.PAYMENT_TX),
  /**
   * 4616-开户/绑卡查询
   */
  TX_4616_REQUEST("4616", "4616-开户/绑卡查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 4643-提现(API)
   */
  TX_4643_REQUEST("4643", "4643-提现(API)", CpcnUrlType.PAYMENT_TX),
  /**
   * 4656-充值/提现/代付查询
   */
  TX_4656_REQUEST("4656", "4656-充值/提现/代付查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 4665-白名单开通/注销
   */
  TX_4665_REQUEST("4665", "4665-白名单开通/注销", CpcnUrlType.PAYMENT_TX),
  /**
   * 4666-白名单开通/注销记录查询
   */
  TX_4666_REQUEST("4666", "4666-白名单开通/注销记录查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 4691-用户信息查询
   */
  TX_4691_REQUEST("4691", "4691-用户信息查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 4698-电子回单下载
   */
  TX_4698_REQUEST("4698", "4698-电子回单下载", CpcnUrlType.GATEWAY4FILE),
  /**
   * 5011-支付(API)
   */
  TX_5011_REQUEST("5011", "5011-支付(API)", CpcnUrlType.PAYMENT_TX),
  /**
   * 5014-订单关闭
   */
  TX_5014_REQUEST("5014", "5014-订单关闭", CpcnUrlType.PAYMENT_TX),
  /**
   * 5016-支付查询
   */
  TX_5016_REQUEST("5016", "5016-支付查询", CpcnUrlType.PAYMENT_TX),
  /**
   * 5021-退款
   */
  TX_5021_REQUEST("5021", "5021-退款", CpcnUrlType.PAYMENT_TX),
  /**
   * 5026-退款查询
   */
  TX_5026_REQUEST("5026", "5026-退款查询", CpcnUrlType.PAYMENT_TX),

  TX_5081_REQUEST("5081", "5081-冻结订单分账撤销", CpcnUrlType.PAYMENT_TX),
  TX_5086_REQUEST("5086", "5086-冻结订单分账撤销查询", CpcnUrlType.PAYMENT_TX),
  TX_5088_REQUEST("5088", "5088-冻结订单分账撤销通知", CpcnUrlType.PAYMENT_TX),

  TX_4692_REQUEST("4692", "4692-用户账户明细信息查询", CpcnUrlType.PAYMENT_TX),
  ;

  /**
   * code
   */
  private final String code;

  /**
   * 描述
   */
  private final String desc;

  /**
   * 请求链接类型
   */
  private final CpcnUrlType urlType;

  public static CpcnRequestType getByCode(String code) {
    for (CpcnRequestType type : CpcnRequestType.values()) {
      if (type.getCode().equals(code)) {
        return type;
      }
    }
    return null;
  }
}
