package com.biz.crm.cpcnpay.core.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author Keller
 */
@Getter
@AllArgsConstructor
public enum CpcnUrlType {

  /**
   * 支付平台支付接口地址
   */
  PAYMENT_PAYMENT("payment_payment", "支付平台支付接口地址"),
  /**
   * 支付平台交易接口地址
   */
  PAYMENT_TX("payment_tx", "支付平台交易接口地址"),
  /**
   * 统一下单接口地址
   */
  GATEWAY4AGGREGATE_PAYMENT("gateway4aggregate_payment", "统一下单接口地址"),
  /**
   * 支付平台交易接口地址
   */
  GATEWAY4AGGREGATE_TX("gateway4aggregate_tx", "支付平台交易接口地址"),
  /**
   * 跨境Gateway页面跳转地址
   */
  CROSSBORDER_PAYMENT("crossborder_payment","跨境Gateway页面跳转地址"),
  /**
   * 跨境Gateway同步交易接口地址
   */
  CROSSBORDER_TX("crossborder_tx","跨境Gateway同步交易接口地址"),
  /**
   * Gateway4File 文件接口地址
   */
  GATEWAY4FILE("gateway4file",""),
  ;

  /**
   * code
   */
  private final String code;

  /**
   * 描述
   */
  private final String desc;
}
