package com.biz.crm.cpcnpay.core.service.internal;

import com.biz.crm.cpcnpay.core.service.TxService;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.strategy.tx.TxManager;
import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 中金接口调用实现类
 * <p>
 * 采用策略模式统一封装，传递接口编号以及请求报文封装request对象即可
 * 传递对象属性信息可以查看对象属性注释或者中金接口文档
 * 接口编号与中金文档中的接口编号一一对应
 *
 * @author Keller
 */
@Slf4j
@Service
public class TxServiceImpl implements TxService {
  @Autowired
  private TxManager txManager;

  @Override
  public TxBaseResponse handlerTx(String code, TxBaseRequest request) {
    request.setTxCode(code);
    log.error("com.biz.crm.cpcnpay.core.service.internal.TxServiceImpl.handlerTx code={}",code);
    AbstractTxStrategy strategy = txManager.getHandler(code);
    log.error("txManager.getHandler code={},strategy={}",code,strategy.getCode());
    TxBaseResponse handler = strategy.handler(request);
    log.error("strategy.handler message={},ResponseMessage={}", handler.getMessage(), handler.getResponseMessage());
    return handler;
  }
}
