package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice5018Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice5018Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 5018-支付通知
 * <pre>
 *   机构系统通过该接口可以对 5011-支付(API)和 5012-支付(页面)交易进行查询，
 *   支付平台返回该笔支付交易的支付状态、支付方式、支付成功时间等信息。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice5018Strategy implements NoticeStrategy<Notice5018Request> {
  @Autowired(required = false)
  private List<Notice5018Listener> notice5018Listeners;
  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_5018.getCode();
  }

  @Override
  public Notice5018Request exchange(NoticeRequest request) throws Exception {
    return new Notice5018Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice5018Request notice5018Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice5018Listeners)) {
        for (Notice5018Listener listener : notice5018Listeners) {
          listener.onNotice(notice5018Request);
        }
      }
    } catch (Exception e) {
      log.error("支付通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
