package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 未找到对应的响应策略处理器默认输入信息
 *
 * @author Keller
 */
@Slf4j
@Component
public class NilTxStrategy extends AbstractTxStrategy {

  @Override
  public String getCode() {
    return "";
  }

  @Override
  public Class<?> getResponse() {
    return null;
  }

  @Override
  public TxBaseResponse handler(TxBaseRequest request) {
    log.error(String.format("数据未找到处理器%s", JSONObject.toJSONString(request)));
    return super.handler(request);
  }
}
