package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.gatheringaccredit.Tx2735Request;
import com.biz.crm.cpcnpay.core.tx.gatheringaccredit.Tx2735Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 2735-商户进件状态查询
 *
 * <pre>
 *    机构系统通过该接口可以对 2734-商户进件接口发生的交易进行 查询，支付平台返回申请流水号对应的该笔进件交易的进件状态等 信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx2735Strategy extends AbstractTxStrategy<Tx2735Request, Tx2735Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_2735_REQUEST.getCode();
  }

  @Override
  public Class<Tx2735Response> getResponse() {
    return Tx2735Response.class;
  }
}
