package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.gatheringaccredit.Tx2751Request;
import com.biz.crm.cpcnpay.core.tx.gatheringaccredit.Tx2751Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 2751-卡 bin 信息查询
 *
 * <pre>
 *    机构系统通过该接口可以对银行账号信息进行查询，如果查询 成功，支付平台会返回该银行账号对应的卡介质类型和发卡行 ID。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx2751Strategy extends AbstractTxStrategy<Tx2751Request, Tx2751Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_2751_REQUEST.getCode();
  }

  @Override
  public Class<Tx2751Response> getResponse() {
    return Tx2751Response.class;
  }
}
