package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.foundationaccount.Tx4656Request;
import com.biz.crm.cpcnpay.core.tx.foundationaccount.Tx4656Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4656-充值/提现/代付查询
 *
 * <pre>
 *    机构系统通过该接口可以对充值交易(4641-充值)、提现交易(4643-提现)、代付交易(4645-单笔代付)进行查询，
 *    请求报文中包含机构编号、原交易流水号、原业务交易编码必传信息，
 *    支付平台返回该笔交易的原交易流水号、金额、交易状态等相关信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4656Strategy extends AbstractTxStrategy<Tx4656Request, Tx4656Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4656_REQUEST.getCode();
  }

  @Override
  public Class<Tx4656Response> getResponse() {
    return Tx4656Response.class;
  }
}
