package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.foundationaccount.Tx4691Request;
import com.biz.crm.cpcnpay.core.tx.foundationaccount.Tx4691Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4691-用户信息查询
 *
 * <pre>
 *     机构系统使用该接口可以对用户信息进行查询，
 *     支付平台返回该用户的用户名称、用户号码、
 *     可用账户余额、冻结账户余额、用户类型、账户状态等信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4691Strategy extends AbstractTxStrategy<Tx4691Request, Tx4691Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4691_REQUEST.getCode();
  }

  @Override
  public Class<Tx4691Response> getResponse() {
    return Tx4691Response.class;
  }
}
