package com.biz.crm.cpcnpay.core.tx.cancleAccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 5081-冻结订单分账撤销
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5081Request extends TxBaseRequest {
  /**
   * 分账撤销流水号
   */
  @NotBlank(message = "分账撤销流水号不能为空")
  private String txSN;
  /**
   * 原支付交易流水号，5011 的交易流水号
   */
  @NotBlank(message = "原支付交易流水号，5011 的交易流水号不能为空")
  private String paymentTxSN;
  /**
   * 原支付交易时间，格式：yyyyMMdd；(支持一年以内的交易)
   */
  @NotBlank(message = "原支付交易时间不能为空")
  private String sourceTxTime;
  /**
   * 后台通知地址
   */
  private String noticeURL;

  /**
   * 备注信息
   */
  private String remark;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element txSN = document.createElement("TxSN");
    Element paymentTxSN = document.createElement("PaymentTxSN");
    Element sourceTxTime = document.createElement("SourceTxTime");
    Element noticeURL = document.createElement("NoticeURL");
    Element remark = document.createElement("Remark");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(txSN);
    txSN.setTextContent(this.txSN);
    Body.appendChild(paymentTxSN);
    paymentTxSN.setTextContent(this.paymentTxSN);
    Body.appendChild(sourceTxTime);
    sourceTxTime.setTextContent(this.sourceTxTime);
    Body.appendChild(noticeURL);
    noticeURL.setTextContent(this.noticeURL);
    Body.appendChild(remark);
    remark.setTextContent(this.remark);
    postProcess(document);
  }
}
