package com.biz.crm.cpcnpay.core.tx.cancleAccount;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 5081-冻结订单分账撤销 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx5081Response extends TxBaseResponse {
  /**
   * 机构编号
   */
  private String institutionID;

  /**
   * 分账撤销交易流水号
   */
  private String txSN;

  /**
   * 分账撤销交易状态
   * 10=受理成功
   * 20=撤销成功
   * 30=撤销失败
   */
  private String status;

  /**
   * 撤销成功时间，Status=20 时非空，格式：
   * yyyyMMddHHmmssSSS
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;

  public Tx5081Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    }
  }
}
