package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4643-提现(API) 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4643Response extends TxBaseResponse {
  /**
   * 交易流水号
   */
  private String txSN;
  /**
   * 金额
   */
  private String amount;
  /**
   * 交易状态
   * <p>
   * 20=处理中
   * 40=失败
   */
  private String status;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx4643Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.amount = XmlUtils.getNodeText(document, "Amount");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }

}
