/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.common.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.biz.crm.cpcnpay.common.security.Signer;
import com.biz.crm.cpcnpay.common.utils.DgEnvUtils;
import com.biz.crm.cpcnpay.common.utils.PayUtils;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;

public class SMSigner
implements Signer {
    private PrivateKey privateKey;
    private X509Cert x509Cert;
    private static final Mechanism mechanism = new Mechanism("SM2");
    private static Session session;

    public SMSigner(String filename, String password) throws Exception {
        this(filename, password, null);
    }

    public SMSigner(String filename, String password, String serviceID) throws Exception {
        this.x509Cert = CertUtil.getCertFromSM2((String)filename);
        this.privateKey = KeyUtil.getPrivateKeyFromSM2((String)filename, (String)password);
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        session = JCrypto.getInstance().openSession("JSOFT_LIB");
    }

    @Override
    public String sign(String message) throws Exception {
        return PayUtils.bytes2hex(this.sign(message.getBytes()));
    }

    @Override
    public byte[] sign(byte[] data, String algorithm) throws Exception {
        return this.sign(data);
    }

    @Override
    public byte[] sign(byte[] data) throws Exception {
        Signature signature = new Signature();
        return Base64.decode((byte[])signature.p7SignMessageDetach("sm3WithSM2Encryption", data, this.privateKey, this.x509Cert, session));
    }

    @Override
    public String decrypt(String message, String digitalEnvelope) throws Exception {
        digitalEnvelope = new String(EncryptUtil.decrypt((Mechanism)mechanism, (Key)this.privateKey, (byte[])digitalEnvelope.getBytes(), (Session)session), StandardCharsets.UTF_8);
        String[] strs = digitalEnvelope.split("\\|");
        return DgEnvUtils.generatePlainText(strs, message);
    }

    @Override
    public String getSN() {
        return String.valueOf(this.x509Cert.getStringSerialNumber());
    }

    @Override
    public String decrypt(String message) throws Exception {
        return new String(EncryptUtil.decrypt((Mechanism)mechanism, (Key)this.privateKey, (byte[])message.getBytes(), (Session)session), StandardCharsets.UTF_8);
    }

    @Override
    public String getSymmetricCipher() {
        return PayUtils.randomHexString(16);
    }

    @Override
    public String getAlgorithm() {
        return this.x509Cert.getSignatureAlgName();
    }
}

